--[[ Kata BattleReport v4.1
This script is based on "battle_report-3.0.lua" by Jon Irons
]]

Triggers = {}

STR = 80
DEFAULT = ""
local ccc
for ccc=1, STR do DEFAULT=DEFAULT.." " end
x6 = DEFAULT
BUFFER = " "
lastMsg = BUFFER
msgString = DEFAULT
scroll = {}
local l
for l=0, number_of_players()-1, 1 do
	scroll[l] = 0
end
TIME = 2
subscroll = TIME
STR_LEN = STR
SKIP = 1

projectiles={};
projectiles[0] = "rockets";
projectiles[1] = "grenades";
projectiles[2] = "pistols";
projectiles[3] = "assaults";
projectiles[4] = "wastes";
projectiles[5] = "fries";
projectiles[6] = "fries";
projectiles[7] = "melts";
projectiles[8] = "s'phts on";
projectiles[9] = "s'phts on";
projectiles[10]= "alienates";
projectiles[11] = "fuses";
projectiles[12] = "overloads";
projectiles[13] = "hunts";
projectiles[14] = "punches";
projectiles[15] = "unuses";
projectiles[16] = "really unuses";
projectiles[17] = "juggs";
projectiles[18] = "pops";
projectiles[19] = "annoys";
projectiles[20] = "sort of defends";
projectiles[21] = "really defends";
projectiles[22] = "juggs";
projectiles[23] = "drains";
projectiles[24] = "drains";
projectiles[25] = "takes the oxygen of";
projectiles[26] = "hums";
projectiles[27] = "hums";
projectiles[28] = "hums";
projectiles[29] = "bounces a grenade into";
projectiles[30] = "bounces a grenade into";
projectiles[31] = "balls";
projectiles[32] = "electrocutes";
projectiles[33] = "zaps";
projectiles[34] = "fries";
projectiles[35] = "slaps";
projectiles[36] = "slimes";
projectiles[37] = "cooks";
projectiles[38] = "puts holes in";


function Triggers.init()
	for p in Players() do
		p._rank = 1
	end
end



function Triggers.player_killed(player, aggressor_player, action, projectile)
	if (lastMsg == BUFFER) then
		msgString = DEFAULT
		local bbb
		for bbb=0, number_of_players(), 1 do
			scroll[bbb] = 0
		end
	end
	if (player ~= -1) then
		if aggressor_player == -1 or aggressor_player == nil then
			lastMsg = "<"..player.name.."> dies. "
			msgString = msgString..lastMsg
			if Game.type ==  "kill monsters" then
				player.points = player.points - 1 
			end
		elseif aggressor_player == player then
			if (projectile_index_valid(projectile.index)) then
				local type = projectile.type.index
				if projectiles[type] then
					lastMsg = "<"..player.name.."> "..projectiles[type].." himself. "
					msgString = msgString..lastMsg
					if Game.type ==  "kill monsters" then
						player.points = player.points - 1 
					end
				end
			end		
		else
			if projectile_index_valid(projectile.index) then
				local type = projectile.type.index
				if (projectiles[type]) then
					lastMsg = "<"..aggressor_player.name.."> "..projectiles[type].." <"..player.name..">. "
					msgString = msgString..lastMsg
					if Game.type ==  "kill monsters" then
						player.points = player.points - 1 
						aggressor_player.points = aggressor_player.points + 1 
					end
				end
			end
		end
	end
	if Game.type == "kill monsters" then
		rank()
	end
end

function scroll_text(player)
	local diff = string.len(msgString) - scroll[player]
	if (diff > (3*STR_LEN)) then SKIP = 4 else SKIP = 1 end
	if (subscroll == 0) then
		scroll[player] = scroll[player] + SKIP
		if (scroll[player] > string.len(msgString)) then
			lastMsg = BUFFER
			msgString = msgString..lastMsg
		end
	end
	local msg = msgString
	local sub = string.sub(msg, scroll[player], scroll[player] + STR_LEN)
	return sub
end

function rank()
	for p in Players() do
		p._rank = 1
		for i = 0, #Players - 1 do
			if Game.type ~= "tag" then
				if Players[i].points > p.points then
					p._rank = p._rank + 1
				end
			else
				if Players[i].points < p.points then
					p._rank = p._rank + 1
				end
			end
		end
	end
end

function Triggers.idle()
	if Game.type ~= "kill monsters" then
		rank()
	end

	subscroll = subscroll - 1
	local lm = ""
	local f
	for f=1, SKIP, 1 do
		lm = lm.." "
	end
	BUFFER = lm
	local z = local_player_index()
	mini = scroll_text(z)
	if (subscroll <= 0) then subscroll = TIME end

	for p in Players() do
		p.overlays[3].color = 0
		p.overlays[3].text = mini

		if Game.type ==  "kill monsters" then
			p.overlays[1].text = "Score: "..p.points..""
		end
		if (p._rank == 1) then
			p.overlays[0].color = 3
		elseif (p._rank == #Players) then
			p.overlays[0].color = 2
		elseif (p._rank == #Players - 1) then
			p.overlays[0].color = 5
		else
			p.overlays[0].color = 1
		end
		
		p.overlays[0].text = "Rank: "..p._rank.."\/"..#Players..""
		if (Game.time_remaining ~= nil) then
			if (math.mod(Game.time_remaining/30, 60) < 10) then zero = "0" else zero = "" end
			p.overlays[2].text = "Time: "..math.floor(Game.time_remaining/1800)..":"..(zero)..""..math.floor(math.mod(Game.time_remaining/30, 60)).. ""
			if (Game.time_remaining/30 == 60) then
				p.overlays[2].color = "5"
			end
			if (Game.time_remaining/30 == 30) then
				p.overlays[2].color = "2"
			end
		end
	end
end